function [total_fvs, total_ffits_1exp, total_ffits_2exp, total_voltages, total_data]=fluo_data_exporter(f_data)

%This file is to accumulate data from the structure into arrays for
%averaging, statistics, export to excel, etc. It is called by
%fluorescencewrapper

%Find the names of the samples and set equal to a variable for use later in
%the for loop constructing each array
sample_names=fieldnames(f_data.fvs);
%Determine the number of samples being used
samples=length(fieldnames(f_data.fvs));

%Determine the maximum number of voltages and put that into a column vector
voltage_number=length(f_data.fvoltage.(sample_names{1}));
total_voltage_length=0;
for n=2:samples
    total_voltage_length=total_voltage_length+length(f_data.fvoltage.(sample_names{n}));
    if length(f_data.fvoltage.(sample_names{n}))>=voltage_number
        voltage_number=length(f_data.fvoltage.(sample_names{n}));
        %master_voltage=f_data.fvoltage.(sample_names{n});
    end
end

%Now put every available voltage into a column and use unique to find each
%unique voltage value
B=[];%(total_voltage_length,1);
for n=1:samples
    A=f_data.fvoltage.(sample_names{n});
    B=vertcat(B,A);
end
all_voltages=unique(B);
voltage_number=length(all_voltages);

%Code below is to expand each array with NaNs so that it fits into the
%total array nicely
for n=1:samples
    if (length(f_data.fvs.(sample_names{n}))<voltage_number)
        blank_rows=voltage_number-length(f_data.fvoltage.(sample_names{n}));
        f_data.fvoltage.(sample_names{n})=vertcat(f_data.fvoltage.(sample_names{n}),NaN(blank_rows, 1));
        f_data.fvs.(sample_names{n})=vertcat(f_data.fvs.(sample_names{n}),NaN(blank_rows,1));
        f_data.ffits_1exp.(sample_names{n})=vertcat(f_data.ffits_1exp.(sample_names{n}),NaN(blank_rows,2));
        f_data.ffits_2exp.(sample_names{n})=vertcat(f_data.ffits_2exp.(sample_names{n}),NaN(blank_rows,5));
    end
end

total_voltages=zeros([voltage_number samples]);

for n=1:samples
    total_voltages(:,n)=f_data.fvoltage.(sample_names{n});
end

%Initialize some variables for speed. Note the odd numbering for the fits... if you decide to change
%the column amount (for example, a weighted tau if the 2exp, or a column
%for measuring lag) you will need to change these indices accordingly
total_fvs=zeros([voltage_number samples]);
total_ffits_1exp=zeros([voltage_number samples*2]);
total_ffits_2exp=zeros([voltage_number samples*5]);
%total_voltages=zeros([voltage_number samples]);
total_data=zeros([voltage_number samples*14]);
%Make a blank column so the exported data looks a little nicer
blank_column=NaN(voltage_number,1);

%Put the data into arrays (all fvs, all 1exp fits, all 2exp fits, and all
%voltages. Note the odd numbering for the fits... if you decide to change
%the column amount (for example, a weighted tau if the 2exp, or a column
%for measuring lag) you will need to change these indices accordingly
%i=1;
for i=1:voltage_number
    for n=1:samples
        for j=1:voltage_number
            if total_voltages(j,n)==all_voltages(i,1)
                total_fvs(i,n)=f_data.fvs.(sample_names{n})(j);
                %f_data.fvs.(sample_names{n})
                %f_data.ffits_1exp(sample_names{n})
                total_ffits_1exp(i,n*2-1:n*2)=f_data.ffits_1exp.(sample_names{n})(j,:);
                total_ffits_2exp(i,n*5-4:n*5)=f_data.ffits_2exp.(sample_names{n})(j,:);
                %total_voltages(i,n)=f_data.fvoltage.(sample_names{n})(j);
                %total_data(:,(n*13)-12:n*13)=horzcat(total_voltages(:,n),total_fvs(:,n),blank_column, blank_column,total_ffits_1exp(:,n*2),blank_column, total_ffits_2exp(:,n*5-3:n*5),blank_column, blank_column, blank_column);
                %else
                %   total_fvs(i,n)=NaN;
                %  total_ffits_1exp(i,n*2-1:n*2)=NaN;
                % total_ffits_2exp(i,n*5-4:n*5)=NaN;
                %total_voltages(i,n)=NaN;
                %Put data into groupings by sample
                %total_data(:,(n*13)-12:n*13)=horzcat(total_voltages(:,n),total_fvs(:,n),blank_column, blank_column,total_ffits_1exp(:,n*2),blank_column, total_ffits_2exp(:,n*5-3:n*5),blank_column, blank_column, blank_column);
            end
        end
        total_data(:,(n*14)-13:n*14)=horzcat(all_voltages(:,1),total_fvs(:,n),blank_column, blank_column,total_ffits_1exp(:,n*2-1:n*2),blank_column, total_ffits_2exp(:,n*5-3:n*5),blank_column, blank_column, blank_column);
    end
end

%Assign the total data to the workspace, note that this is considered poor
%programming
assignin('base','total_f_data', total_data);

%Now produce a file with a user entered name and directory location
[filename, path]=uiputfile('*.xlsx','Save Data As');
full_filename=fullfile(path, filename);
%Now save all the data into it. B2 sets the row and column in excel that
%the data will start at
xlswrite(full_filename, total_data,1, 'B2');


%%%%%%%%%%%%%%%%%Below is scrap code from when this was being
%%%%%%%%%%%%%%%%%developed%%%%%%%%%%%%%%%%%%%%
%for n=1:samples
%for i=1:voltage_number
%   if total_voltages(i,n)==master_voltage(i)
%      total_fvs(i,n)=total_fvs(i,n);
%     total_ffits_1exp(i,n)=total_ffits_1exp(i,n);
%    total_ffits_1exp(i,n)=total_ffits_2exp
%end